/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.base;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSBusinessService;
import filenet.ws.api.uddi.WSTModel;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.utils.WSValidateServerCertificate;
import java.awt.event.ItemListener;
import java.net.ConnectException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;

public class VWUDDIRegistryItem {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_CONNECTED = 1;
    public static final int STATE_UNREACHABLE = 2;
    private URL m_inquiryURL = null;
    private URL m_publishURL = null;
    private VWUDDIBusinessItem m_vwBusinessItem = null;
    private boolean m_bPublish = false;
    private WSUDDIRegistry m_wsUddiRegistry = null;
    private VWUDDIRegistry m_vwUddiRegistry = null;
    private boolean m_bNeedRefreshServices = true;
    private Vector m_services = null;
    private Hashtable m_tModels = null;
    private int m_registryState = 0;
    private String m_logonUser = null;
    private Vector m_changeListeners = new Vector();

    public VWUDDIRegistryItem(VWUDDIRegistry uddiRegistry) {
        this(uddiRegistry.getName(), uddiRegistry.getInquiryURL(), uddiRegistry.getPublishURL(), uddiRegistry.getPublish());
        this.m_vwUddiRegistry = uddiRegistry;
        this.m_bNeedRefreshServices = true;
    }

    public VWUDDIRegistryItem(String name, String inquiryURL, String publishURL, boolean bPublish) {
        try {
            this.m_wsUddiRegistry = new WSUDDIRegistry(name, inquiryURL, publishURL, bPublish);
        }
        catch (Exception ex) {
            VWDebug.logException(ex, "UDDIRegistryItem(name, inquiryURL, publishURL, bPublish)");
        }
        try {
            this.m_inquiryURL = this.m_wsUddiRegistry != null ? this.m_wsUddiRegistry.getInquiryURL() : null;
        }
        catch (Exception ex) {
            this.m_inquiryURL = null;
        }
        try {
            this.m_publishURL = this.m_wsUddiRegistry != null ? this.m_wsUddiRegistry.getPublishURL() : null;
        }
        catch (Exception ex) {
            this.m_publishURL = null;
        }
        this.m_bPublish = bPublish;
        this.m_bNeedRefreshServices = true;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (!this.m_changeListeners.contains(l)) {
            this.m_changeListeners.add(l);
        }
    }

    public synchronized void removeItemListener(ItemListener l) {
        if (this.m_changeListeners.contains(l)) {
            this.m_changeListeners.remove(l);
        }
    }

    public VWUDDIBusinessItem newBusiness(String name) throws Exception {
        BusinessEntity uddiBusinessEntity = new BusinessEntity();
        Name aName = new Name(name, Locale.getDefault().getLanguage());
        Vector<Name> v = new Vector<Name>();
        v.add(aName);
        uddiBusinessEntity.setNameVector(v);
        this.m_vwBusinessItem = new VWUDDIBusinessItem(this.m_wsUddiRegistry, uddiBusinessEntity);
        VWUDDIBusinessEntity vwBusinessEntity = new VWUDDIBusinessEntity();
        vwBusinessEntity.setBusinessEntity(uddiBusinessEntity);
        this.m_vwUddiRegistry.addBusinessEntity(vwBusinessEntity);
        this.m_vwBusinessItem.setNewBusiness(true);
        return this.m_vwBusinessItem;
    }

    public void setBusinessItem(VWUDDIBusinessItem vwBusinessItem) throws Exception {
        this.m_vwBusinessItem = vwBusinessItem;
        VWUDDIBusinessEntity vwBusinessEntity = new VWUDDIBusinessEntity();
        BusinessEntity uddiBusinessEntity = this.m_vwBusinessItem.getBusinessEntity();
        vwBusinessEntity.setBusinessEntity(uddiBusinessEntity);
        this.m_vwUddiRegistry.addBusinessEntity(vwBusinessEntity);
    }

    public VWUDDIBusinessItem createVWBusinessItem() throws Exception {
        BusinessEntity uddiBusinessEntity = this.getBusinessEntity();
        this.m_vwBusinessItem = new VWUDDIBusinessItem(this.m_wsUddiRegistry, uddiBusinessEntity);
        return this.m_vwBusinessItem;
    }

    public VWUDDIBusinessItem getVWBusinessItem() throws Exception {
        if (this.m_vwBusinessItem == null) {
            try {
                BusinessEntity uddiBusinessEntity = this.getBusinessEntity();
                if (uddiBusinessEntity != null) {
                    String key = uddiBusinessEntity.getBusinessKey();
                    this.m_vwBusinessItem = key != null && key.length() > 0 ? this.findBusinessItemByKey(key) : new VWUDDIBusinessItem(this.m_wsUddiRegistry, uddiBusinessEntity);
                }
            }
            catch (Exception ex) {
                VWDebug.logWarning("rethrowing exception from VWUDDIRegistryItem::getBusinessEntity()");
                throw ex;
            }
        }
        return this.m_vwBusinessItem;
    }

    public BusinessEntity getBusinessEntity() {
        VWUDDIBusinessEntity vwBusinessEntity;
        BusinessEntity businessEntity = null;
        if (this.m_vwUddiRegistry != null && (vwBusinessEntity = this.m_vwUddiRegistry.getVWBusinessEntity(0)) != null) {
            businessEntity = vwBusinessEntity.getBusinessEntity();
        }
        return businessEntity;
    }

    public String getBusinessEntityKey() {
        if (this.m_vwUddiRegistry != null) {
            String key = this.m_vwUddiRegistry.getBusinessKey();
            if (key != null && key.length() == 0) {
                key = null;
            }
            return key;
        }
        return null;
    }

    public WSBusinessService[] getBusinessServices(VWUDDIBusinessItem businessItem) {
        if (businessItem != null) {
            try {
                if (businessItem != this.m_vwBusinessItem) {
                    String key = businessItem.getBusinessKey();
                    String thisKey = this.getBusinessEntityKey();
                    if (thisKey == null || key == null || thisKey.compareTo(key) != 0) {
                        return null;
                    }
                }
                if (this.m_bNeedRefreshServices) {
                    this.searchBusinessServices(false);
                }
                if (this.m_services != null && this.m_services.size() > 0) {
                    WSBusinessService[] services = new WSBusinessService[this.m_services.size()];
                    this.m_services.toArray(services);
                    return services;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex, "VWUDDIRegistryItem::getBusinessServices()");
            }
        }
        return null;
    }

    public WSTModel[] getTModels(WSBusinessService service) {
        Object obj;
        if (service != null && this.m_tModels != null && (obj = this.m_tModels.get(service)) instanceof WSTModel[]) {
            return (WSTModel[])obj;
        }
        return null;
    }

    public VWUDDIBusinessItem findBusinessItemByKey(String businessKey) throws Exception {
        VWUDDIBusinessItem businessItem = null;
        WSBusinessEntity wsBusinessEntity = this.m_wsUddiRegistry.findBusinessByKey(businessKey);
        if (wsBusinessEntity != null) {
            businessItem = new VWUDDIBusinessItem(wsBusinessEntity);
        }
        return businessItem;
    }

    public WSUDDIRegistry getWSUDDIRegistry() {
        return this.m_wsUddiRegistry;
    }

    public VWUDDIRegistry getVWUDDIRegistry() {
        return this.m_vwUddiRegistry;
    }

    public String getName() {
        if (this.m_wsUddiRegistry != null) {
            return this.m_wsUddiRegistry.getName();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public String getInquiryURL() {
        if (this.m_inquiryURL != null) {
            return this.m_inquiryURL.toString();
        }
        return null;
    }

    public boolean getPublish() {
        return this.m_bPublish;
    }

    public String getPublishURL() {
        if (this.m_publishURL != null) {
            return this.m_publishURL.toString();
        }
        return null;
    }

    public boolean isAuthenticated() {
        if (this.m_wsUddiRegistry != null) {
            return this.m_wsUddiRegistry.isAuthenticated();
        }
        return false;
    }

    public boolean setUserInfo(String name, String password) {
        try {
            if (this.m_wsUddiRegistry != null) {
                this.m_wsUddiRegistry.setUserInfo(name, password);
                return this.isAuthenticated();
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public String getBusinessName() {
        if (this.m_vwUddiRegistry != null) {
            return this.m_vwUddiRegistry.getBusinessName();
        }
        return null;
    }

    public String getBusinessDescription() {
        if (this.m_vwUddiRegistry != null) {
            return this.m_vwUddiRegistry.getBusinessDescription();
        }
        return null;
    }

    public boolean deleteBusinessService(WSBusinessService service) throws Exception {
        boolean result = false;
        if (this.m_wsUddiRegistry == null || service == null) {
            return result;
        }
        if (this.m_services != null && this.m_services.contains(service)) {
            this.m_services.remove(service);
            result = this.m_wsUddiRegistry.deleteService(service);
            this.m_bNeedRefreshServices = true;
            return result;
        }
        return result;
    }

    public boolean deleteBusinessEntity(VWUDDIBusinessItem businessItem) throws Exception {
        boolean result = false;
        if (this.m_wsUddiRegistry == null || businessItem == null) {
            return result;
        }
        if (businessItem == this.m_vwBusinessItem) {
            result = this.m_wsUddiRegistry.deleteBusinessEntity(businessItem.getWSBusinessEntity());
            this.m_bNeedRefreshServices = true;
            this.m_vwBusinessItem = null;
            return result;
        }
        return result;
    }

    public boolean getNeedRefreshServices() {
        return this.m_bNeedRefreshServices;
    }

    public void setNeedRefreshServices(boolean bNeedRefresh) {
        this.m_bNeedRefreshServices = bNeedRefresh;
    }

    public boolean validateCert() throws Exception {
        String[] urls = new String[]{this.getPublishURL()};
        boolean[] validated = new boolean[]{false};
        WSValidateServerCertificate validateCert = new WSValidateServerCertificate();
        validated = validateCert.validateServers(urls);
        Exception[] exceptions = validateCert.getValidateServerExceptions();
        if (exceptions != null && exceptions.length > 0 && exceptions[0] != null) {
            this.m_registryState = 2;
            throw exceptions[0];
        }
        if (validated[0]) {
            this.m_registryState = 1;
        }
        return validated[0];
    }

    public void refresh() throws Exception {
        if (this.m_registryState == 1) {
            try {
                this.m_bNeedRefreshServices = true;
                this.searchBusinessServices(true);
                this.m_bNeedRefreshServices = false;
                if (this.m_changeListeners != null) {
                    for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                        ((ChangeListener)this.m_changeListeners.get(i)).stateChanged(new ChangeEvent(this));
                    }
                }
            }
            catch (ConnectException ex) {
                this.m_registryState = 2;
                throw ex;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
    }

    public void setLogonUser(String logonUser) {
        this.m_logonUser = logonUser;
    }

    public String getLogonUser() {
        return this.m_logonUser;
    }

    public int getState() {
        return this.m_registryState;
    }

    public void setState(int state) {
        this.m_registryState = state;
    }

    public boolean isConnected() {
        return this.m_registryState == 1;
    }

    public void searchBusinessServices(boolean bRefreshBusiness) throws Exception {
        if (!this.m_bNeedRefreshServices) {
            return;
        }
        try {
            if (this.m_vwBusinessItem == null) {
                this.getVWBusinessItem();
                if (this.m_vwBusinessItem == null) {
                    return;
                }
            } else if (bRefreshBusiness && this.m_vwBusinessItem.isValid() && this.m_vwBusinessItem.hasBusinessKey()) {
                this.m_vwBusinessItem.refresh();
            }
            Vector services = this.m_vwBusinessItem.getBusinessServices();
            WSBusinessService businessService = null;
            this.m_tModels = new Hashtable();
            Object obj = null;
            Vector<WSTModel> tModelVector = null;
            WSTModel[] tModelArray = null;
            this.cleanupServices();
            this.m_tModels = new Hashtable();
            if (services != null && services.size() > 0) {
                for (int i = services.size() - 1; i >= 0; --i) {
                    obj = services.get(i);
                    if (obj != null && obj instanceof WSBusinessService) {
                        businessService = obj;
                        tModelVector = new Vector<WSTModel>();
                        WSTModel[] tModels = businessService.getTModels();
                        if (tModels == null || tModels.length <= 0) continue;
                        block3: for (int j = 0; j < tModels.length; ++j) {
                            Vector categories;
                            if (tModels[j] == null || (categories = tModels[j].getCategories()) == null) continue;
                            for (int k = 0; k < categories.size(); ++k) {
                                String keyvalue;
                                obj = categories.get(k);
                                if (obj == null || !(obj instanceof KeyedReference) || (keyvalue = ((KeyedReference)obj).getKeyValue()) == null || keyvalue.compareTo("wsdlSpec") != 0) continue;
                                tModelVector.add(tModels[j]);
                                continue block3;
                            }
                        }
                        if (tModelVector == null || tModelVector.size() <= 0) continue;
                        tModelArray = new WSTModel[tModelVector.size()];
                        tModelVector.toArray(tModelArray);
                        this.m_tModels.put(businessService, tModelArray);
                        continue;
                    }
                    services.remove(i);
                }
                this.m_services = services;
            }
        }
        catch (Exception ex) {
            VWDebug.logWarning("rethrowing exception in VWUDDIRegistryItem::searchBusinessServices()");
            throw ex;
        }
        this.m_bNeedRefreshServices = false;
    }

    private void cleanupServices() {
        if (this.m_tModels != null) {
            Object obj = null;
            Object key = null;
            WSTModel[] array = null;
            Enumeration keys = this.m_tModels.keys();
            if (keys != null) {
                while (keys.hasMoreElements()) {
                    key = keys.nextElement();
                    obj = this.m_tModels.get(key);
                    if (obj != null && obj instanceof WSTModel[]) {
                        array = obj;
                        for (int i = 0; i < array.length; ++i) {
                            array[i] = null;
                        }
                    }
                    this.m_tModels.remove(key);
                    array = null;
                }
            }
            this.m_tModels = null;
        }
        if (this.m_services != null) {
            this.m_services.removeAllElements();
            this.m_services = null;
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 09:16:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }
}

